; ===========================================================================
; ROMCAL12.ASM
;
; Mach64 ROM interface function 12h - Get I/O base information.
;
; Compiling:
;   masm /Ml /D<memory model> romcalls.asm;
;       <memory model> = mem_S for SMALL model,
;                        mem_M for MEDIUM model,
;                        mem_L for LARGE model
;
; Copyright (c) 1993-94 ATI Technologies Inc. All rights reserved
; ===========================================================================

include ..\inc\atim64.inc

IFDEF mem_S
PARM        equ     4   ; passed parameters start at bp+4 for small model
ELSE
PARM        equ     6   ; passed parameters start at bp+6 for other models
ENDIF

IFDEF mem_S
.MODEL  SMALL, C
ELSEIFDEF mem_M
.MODEL  MEDIUM, C
ELSE
.MODEL  LARGE, C
ENDIF

.DATA

rom_addr    dw      64h
            dw      0c000h
            db      0

.CODE
.286

; Macro for 'call' model handling
Mcall       macro   routine
IFDEF mem_S
            call    NEAR PTR routine
ELSE
            call    FAR PTR routine
ENDIF
	        endm

; Externals
IFDEF mem_S
extrn   pgl_getrombase:NEAR
ELSE
extrn   pgl_getrombase:FAR
ENDIF

; ---------------------------------------------------------------------------
; ROM_GETIOBASE - ROM function 12h
;
; Retrieve the I/O base address from the ROM. See PGL.H for symbolic values.
;
; Inputs : DWORD PTR address of I/O base structure to be filled
;
; Outputs: Return codes
;            0 - no error
;            1 - function complete with error
;            2 - function not supported
; --------------------------------------------------------------------------
            public  ROM_getiobase

IFDEF mem_S
ROM_getiobase proc near
ELSE
ROM_getiobase proc far
ENDIF
            ; create frame pointer
            push    bp
            mov     bp, sp

            ; save registers used
            push    bx
            push    cx
            push    dx
            push    di
            push    es

            ; setup parameters for call to ATI rom
            Mcall   pgl_getrombase              ; get rom segment in ax
            mov     rom_addr+2, ax
            mov     di, WORD PTR [bp+PARM]      ; get offset of address
            mov     ax, WORD PTR [bp+PARM+2]    ; get segment of address
            mov     es, ax

            ; setup ROM call
            mov     ax, 12h                     ; function 12h
            mov     rom_addr, 64h
            call    DWORD PTR rom_addr          ; call ROM using FAR CALL

            ; retrieve information
            mov     es:[di], dx
            and     cx, 1
            add     di, 2
            mov     es:[di], cx

            ; setup error code in AL
            mov     al, ah
            xor     ah, ah

            ; restore saved registers
            pop     es
            pop     di
            pop     dx
            pop     cx
            pop     bx

            ; remove frame pointer
            mov     sp, bp
            pop     bp

            ret

ROM_getiobase endp

            end

