/******************************************************************************
 * ATI mach64VT/3D RAGE -specific defines file for Chapter 8 sample code.     *
 *                                                                            *
 * Copyright (c) 1994-1998 ATI Technologies Inc.  All rights reserved.        *
 ******************************************************************************/

#ifndef _DEFINEVT_H
#define _DEFINEVT_H

// Since the VT is a superset of the CT, pull in standard DEFINES.H defines.

#include "defines.h"

// GP_IO_CNTL constants.

#define GP_IO_MODE_VIDEO_IO         0x0
#define GP_IO_MODE_VMC              0x1
#define GP_IO_MODE_VFC              0x2
#define GP_IO_MODE_ENG_DIAG         0x3
#define GP_IO_MODE_GP_IO            0x4
#define GP_IO_EN                    0x80000000

// OVERLAY_KEY_CNTL constants.

#define VIDEO_KEY_FALSE             0x0
#define VIDEO_KEY_TRUE              0x1
#define VIDEO_KEY_NOT_EQUAL         0x4
#define VIDEO_KEY_EQUAL             0x5
#define GRAPHICS_KEY_FALSE          0x0
#define GRAPHICS_KEY_TRUE           0x10
#define GRAPHICS_KEY_NOT_EQUAL      0x40
#define GRAPHICS_KEY_EQUAL          0x50
#define OVERLAY_MIX_G_CMP           0x0
#define OVERLAY_MIX_ALWAYS_G        0x100
#define OVERLAY_MIX_ALWAYS_V        0x200
#define OVERLAY_MIX_NOT_G           0x300
#define OVERLAY_MIX_NOT_V           0x400
#define OVERLAY_MIX_G_XOR_V         0x500
#define OVERLAY_MIX_NOT_G_XOR_V     0x600
#define OVERLAY_MIX_V_CMP           0x700
#define OVERLAY_MIX_NOT_G_OR_NOT_V  0x800
#define OVERLAY_MIX_G_OR_NOT_V      0x900
#define OVERLAY_MIX_NOT_G_OR_V      0xA00
#define OVERLAY_MIX_G_OR_V          0xB00
#define OVERLAY_MIX_G_AND_V         0xC00
#define OVERLAY_MIX_NOT_G_AND_V     0xD00
#define OVERLAY_MIX_G_AND_NOT_V     0xE00
#define OVERLAY_MIX_NOT_G_AND_NOT_V 0xF00
#define OVERLAY_EXCLUSIVE_NORMAL    0x0
#define OVERLAY_EXCLUSIVE_V_ONLY    0x80000000

// OVERLAY_SCALE_CNTL constants.

#define SCALE_ZERO_EXTEND           0x0
#define SCALE_DYNAMIC               0x1
#define SCALE_RED_TEMP_6500K        0x0
#define SCALE_RED_TEMP_9800K        0x2
#define SCALE_HORZ_BLEND            0x0
#define SCALE_HORZ_REP              0x4
#define SCALE_VERT_BLEND            0x0
#define SCALE_VERT_REP              0x8
#define SCALE_BANDWIDTH_NORMAL      0x0
#define SCALE_BANDWIDTH_EXCEEDED    0x4000000
#define SCALE_BANDWIDTH_RESET       0x4000000
#define SCALE_CLK_ACTIVITY          0x0
#define SCALE_CLK_CONTINUOUS        0x20000000
#define OVERLAY_DISABLE             0x0
#define OVERLAY_ENABLE              0x40000000
#define SCALE_DISABLE               0x0
#define SCALE_ENABLE                0x80000000

// OVERLAY_TEST constants.

#define SCALE_Y2R_ENABLE            0x0         // normal operation
#define SCALE_Y2R_DISABLE           0x2

// VIDEO_FORMAT constants.

#define VIDEO_IN_8BPP               0x2
#define VIDEO_IN_16BPP              0x4
#define VIDEO_IN_32BPP              0x6
#define VIDEO_IN_VYUY422            0xB         // 16 bpp
#define VIDEO_IN_YVYU422            0xC         // 16 bpp
#define SCALE_IN_15BPP              0x30000     // aRGB 1555
#define SCALE_IN_16BPP              0x40000     // RGB 565
#define SCALE_IN_32BPP              0x60000     // aRGB 8888
#define SCALE_IN_YUV9               0x90000     // planar
#define SCALE_IN_YUV12              0xA0000     // planar
#define SCALE_IN_VYUY422            0xB0000     // 16 bpp
#define SCALE_IN_YVYU422            0xC0000     // 16 bpp
#define HOST_YUV_APERTURE_UPPER     0x0
#define HOST_YUV_APERTURE_LOWER     0x20000000
#define HOST_MEM_MODE_NORMAL        0x0
#define HOST_MEM_MODE_Y             0x40000000
#define HOST_MEM_MODE_U             0x80000000
#define HOST_MEM_MODE_V             0xC0000000

// VIDEO_CONFIG constants.

#define VIDEO_MODE_VIDEO_IN         0x0
#define VIDEO_DEVICE_VMC            0x0
#define VIDEO_DEVICE_VIDEO          0x2         // based on VIDEO_INPUT_TYPE
#define VIDEO_HSYNC_POL_NEG         0x0         // Phillips compatible
#define VIDEO_HSYNC_POL_POS         0x4
#define VIDEO_VSYNC_POL_NEG         0x0         // Phillips compatible
#define VIDEO_VSYNC_POL_POS         0x8
#define VIDEO_IO_SIZE_8BIT          0x0
#define VIDEO_FIELD_NORMAL          0x0
#define VIDEO_FIELD_FLIP            0x40
#define VIDEO_INPUT_TYPE_PARALLEL   0x0         // Philips compatible
#define VIDEO_INPUT_TYPE_EMBEDDED   0x300       // Brooktree compatible
#define VIDEO_HORZ_DOWN_UNITY       0x0
#define VIDEO_HORZ_DOWN_2TO1        0x1000
#define VIDEO_HORZ_DOWN_4TO1        0x2000
#define VIDEO_VERT_DOWN_UNITY       0x0
#define VIDEO_VERT_DOWN_2TO1        0x4000
#define VIDEO_VERT_DOWN_4TO1        0x8000

// CAPTURE_CONFIG constants.

#define VIDEO_IN_CAP_EVEN_DISABLE   0x0
#define VIDEO_IN_CAP_EVEN_AUTO      0x1
#define VIDEO_IN_CAP_EVEN_HOST      0x2
#define VIDEO_IN_CAP_ODD_DISABLE    0x0
#define VIDEO_IN_CAP_ODD_AUTO       0x4
#define VIDEO_IN_CAP_ODD_HOST       0x8
#define VIDEO_IN_FRAME_MODE_FIELD   0x0
#define VIDEO_IN_FRAME_MODE_DEINTER 0x10
#define VIDEO_IN_BUF_MODE_SINGLE    0x0
#define VIDEO_IN_BUF_MODE_DOUBLE    0x20
#define VIDEO_IN_BUF_0              0x0         // Read and Write
#define VIDEO_IN_BUF_1              0x40
#define VIDEO_IN_SYNC_CNTL_VMC_SEND 0x0
#define VIDEO_IN_SYNC_CNTL_VMC_WAIT 0x80
#define SCALER_FRAME_READ_MODE_FULL 0x0
#define SCALER_BUF_MODE_SINGLE      0x0
#define SCALER_BUF_MODE_DOUBLE      0x40000
#define SCALER_BUF_NEXT_0           0x0
#define SCALER_BUF_NEXT_1           0x80000
#define SCALER_BUF_STATUS_0         0x0         // Read only
#define SCALER_BUF_STATUS_1         0x100000    // Read only

// TRIG_CNTL constants.

#define CAPTURE_TRIG_EVEN_NONE      0x0         // Even capture initiate (W)
#define CAPTURE_TRIG_EVEN_CAPTURE   0x1
#define CAPTURE_TRIG_EVEN_COMPLETE  0x0         // Even capture status (R)
#define CAPTURE_TRIG_EVEN_PENDING   0x1
#define CAPTURE_TRIG_EVEN_PROGRESS  0x2
#define CAPTURE_TRIG_ODD_NONE       0x0         // Odd capture initiate (W)
#define CAPTURE_TRIG_ODD_CAPTURE    0x4
#define CAPTURE_TRIG_ODD_COMPLETE   0x0         // Odd capture status (R)
#define CAPTURE_TRIG_ODD_PENDING    0x4
#define CAPTURE_TRIG_ODD_PROGRESS   0x8
#define TRIG_EVEN_BUF_0             0x0         // Last even buffer status (R)
#define TRIG_EVEN_BUF_1             0x10
#define TRIG_ODD_BUF_0              0x0         // Last odd buffer status (R)
#define TRIG_ODD_BUF_1              0x20
#define BUF_RD_STATUS_NOT_READ      0x0         // Overlay scaler buffer
#define BUF_RD_STATUS_READ          0x40
#define BUF_WR_STATUS_NOT_WRITE     0x0         // Overlay capture buffer
#define BUF_WR_STATUS_WRITE         0x80
#define CAPTURE_DISABLE             0x0
#define CAPTURE_ENABLE              0x80000000

// VMC_CONFIG constants.

#define VMC_CLK_DISABLE             0x0
#define VMC_CLK_ENABLE              0x20000
#define VMC_CLK_SRC_EXTERNAL        0x0
#define VMC_CLK_SRC_INTERNAL        0x40000
#define VMC_BYPASS_CYCLE_ENABLE     0x0
#define VMC_BYPASS_CYCLE_DISABLE    0x100000
#define VMC_CLK_OUT_DISABLE         0x0
#define VMC_CLK_OUT_ENABLE          0x200000
#define VMC_STATUS_MODE_NORMAL      0x0
#define VMC_STATUS_MODE_SCHEDULE    0x1000000
#define VMC_STATUS_MODE_DEBUG1      0x2000000
#define VMC_STATUS_MODE_DEBUG2      0x3000000
#define VMC_RESET                   0x0
#define VMC_ENABLE                  0x80000000

// BUS MASTERING constants

#define LAST_DESCRIPTOR (1 << 31)
#define SYSTEM_TO_FRAME_BUFFER 0x0
#define FRAME_BUFFER_TO_SYSTEM 0x1
#define BM_CIR_BUF_SIZE_16K 0
#define BM_CIR_BUF_SIZE_32K 1
#define BM_CIR_BUF_SIZE_64K 2
#define BM_CIR_BUF_SIZE_128K 3
#define SRC_BM_ENABLE (1 << 8)
#define SRC_BM_SYNC (1 << 9)
#define SRC_BM_OP_SYSTEM_TO_FRAME (1 << 10)
#define SRC_BM_OP_SYSTEM_TO_HOST_DATA_REGISTER (3 << 10)


#endif // _DEFINEVT_H
