/*===========================================================================
  ATIM64.H

  C include file that contains ATI MACH64 register definitions

  Copyright (c) 1993-1995 ATI Technologies Inc.  All rights reserved
 ===========================================================================*/

/* NON-GUI IO MAPPED Registers */

#define ioCRTC_H_TOTAL_DISP     0x02EC
#define ioCRTC_H_SYNC_STRT_WID  0x06EC
#define ioCRTC_V_TOTAL_DISP     0x0AEC
#define ioCRTC_V_SYNC_STRT_WID  0x0EEC
#define ioCRTC_VLINE_CRNT_VLINE 0x12EC
#define ioCRTC_OFF_PITCH        0x16EC
#define ioCRTC_INT_CNTL         0x1AEC
#define ioCRTC_GEN_CNTL         0x1EEC

#define ioOVR_CLR               0x22EC
#define ioOVR_WID_LEFT_RIGHT    0x26EC
#define ioOVR_WID_TOP_BOTTOM    0x2AEC

#define ioCUR_CLR0              0x2EEC
#define ioCUR_CLR1              0x32EC
#define ioCUR_OFFSET            0x36EC
#define ioCUR_HORZ_VERT_POSN    0x3AEC
#define ioCUR_HORZ_VERT_OFF     0x3EEC

#define ioSCRATCH_REG0          0x42EC
#define ioSCRATCH_REG1          0x46EC

#define ioCLOCK_SEL_CNTL        0x4AEC

#define ioBUS_CNTL              0x4EEC

#define ioMEM_CNTL              0x52EC
#define ioMEM_VGA_WP_SEL        0x56EC
#define ioMEM_VGA_RP_SEL        0x5AEC

#define ioDAC_REGS              0x5EEC
#define ioDAC_CNTL              0x62EC

#define ioGEN_TEST_CNTL         0x66EC

#define ioCONFIG_CNTL           0x6AEC
#define ioCONFIG_CHIP_ID        0x6EEC
#define ioCONFIG_STAT0          0x72EC
#define ioCONFIG_STAT1          0x76EC


/* NON-GUI MEMORY MAPPED Registers - expressed in BYTE offsets */

#define CRTC_H_TOTAL_DISP       0x0000  // Dword offset 00
#define CRTC_H_SYNC_STRT_WID    0x0004  // Dword offset 01
#define CRTC_V_TOTAL_DISP       0x0008  // Dword offset 02
#define CRTC_V_SYNC_STRT_WID    0x000C  // Dword offset 03
#define CRTC_VLINE_CRNT_VLINE   0x0010  // Dword offset 04
#define CRTC_OFF_PITCH          0x0014  // Dword offset 05
#define CRTC_INT_CNTL           0x0018  // Dword offset 06
#define CRTC_GEN_CNTL           0x001C  // Dword offset 07

#define OVR_CLR                 0x0040  // Dword offset 10
#define OVR_WID_LEFT_RIGHT      0x0044  // Dword offset 11
#define OVR_WID_TOP_BOTTOM      0x0048  // Dword offset 12

#define CUR_CLR0                0x0060  // Dword offset 18
#define CUR_CLR1                0x0064  // Dword offset 19
#define CUR_OFFSET              0x0068  // Dword offset 1A
#define CUR_HORZ_VERT_POSN      0x006C  // Dword offset 1B
#define CUR_HORZ_VERT_OFF       0x0070  // Dword offset 1C

#define SCRATCH_REG0            0x0080  // Dword offset 20
#define SCRATCH_REG1            0x0084  // Dword offset 21

#define CLOCK_SEL_CNTL          0x0090  // Dword offset 24

#define BUS_CNTL                0x00A0  // Dword offset 28

#define MEM_CNTL                0x00B0  // Dword offset 2C

#define MEM_VGA_WP_SEL          0x00B4  // Dword offset 2D
#define MEM_VGA_RP_SEL          0x00B8  // Dword offset 2E

#define DAC_REGS                0x00C0  // Dword offset 30
#define DAC_CNTL                0x00C4  // Dword offset 31

#define GEN_TEST_CNTL           0x00D0  // Dword offset 34

#define CONFIG_CHIP_ID          0x00E0  // Dword offset 38
#define CONFIG_STAT0            0x00E4  // Dword offset 39
#define CONFIG_STAT1            0x00E8  // Dword offset 3A


/* GUI MEMORY MAPPED Registers */

#define DST_OFF_PITCH           0x0100  // Dword offset 40
#define DST_X                   0x0104  // Dword offset 41
#define DST_Y                   0x0108  // Dword offset 42
#define DST_Y_X                 0x010C  // Dword offset 43
#define DST_WIDTH               0x0110  // Dword offset 44
#define DST_HEIGHT              0x0114  // Dword offset 45
#define DST_HEIGHT_WIDTH        0x0118  // Dword offset 46
#define DST_X_WIDTH             0x011C  // Dword offset 47
#define DST_BRES_LNTH           0x0120  // Dword offset 48
#define DST_BRES_ERR            0x0124  // Dword offset 49
#define DST_BRES_INC            0x0128  // Dword offset 4A
#define DST_BRES_DEC            0x012C  // Dword offset 4B
#define DST_CNTL                0x0130  // Dword offset 4C

#define SRC_OFF_PITCH           0x0180  // Dword offset 60
#define SRC_X                   0x0184  // Dword offset 61
#define SRC_Y                   0x0188  // Dword offset 62
#define SRC_Y_X                 0x018C  // Dword offset 63
#define SRC_WIDTH1              0x0190  // Dword offset 64
#define SRC_HEIGHT1             0x0194  // Dword offset 65
#define SRC_HEIGHT1_WIDTH1      0x0198  // Dword offset 66
#define SRC_X_START             0x019C  // Dword offset 67
#define SRC_Y_START             0x01A0  // Dword offset 68
#define SRC_Y_X_START           0x01A4  // Dword offset 69
#define SRC_WIDTH2              0x01A8  // Dword offset 6A
#define SRC_HEIGHT2             0x01AC  // Dword offset 6B
#define SRC_HEIGHT2_WIDTH2      0x01B0  // Dword offset 6C
#define SRC_CNTL                0x01B4  // Dword offset 6D

#define HOST_DATA0              0x0200  // Dword offset 80
#define HOST_DATA1              0x0204  // Dword offset 81
#define HOST_DATA2              0x0208  // Dword offset 82
#define HOST_DATA3              0x020C  // Dword offset 83
#define HOST_DATA4              0x0210  // Dword offset 84
#define HOST_DATA5              0x0214  // Dword offset 85
#define HOST_DATA6              0x0218  // Dword offset 86
#define HOST_DATA7              0x021C  // Dword offset 87
#define HOST_DATA8              0x0220  // Dword offset 88
#define HOST_DATA9              0x0224  // Dword offset 89
#define HOST_DATAA              0x0228  // Dword offset 8A
#define HOST_DATAB              0x022C  // Dword offset 8B
#define HOST_DATAC              0x0230  // Dword offset 8C
#define HOST_DATAD              0x0234  // Dword offset 8D
#define HOST_DATAE              0x0238  // Dword offset 8E
#define HOST_DATAF              0x023C  // Dword offset 8F
#define HOST_CNTL               0x0240  // Dword offset 90

#define PAT_REG0                0x0280  // Dword offset A0
#define PAT_REG1                0x0284  // Dword offset A1
#define PAT_CNTL                0x0288  // Dword offset A2

#define SC_LEFT                 0x02A0  // Dword offset A8
#define SC_RIGHT                0x02A4  // Dword offset A9
#define SC_LEFT_RIGHT           0x02A8  // Dword offset AA
#define SC_TOP                  0x02AC  // Dword offset AB
#define SC_BOTTOM               0x02B0  // Dword offset AC
#define SC_TOP_BOTTOM           0x02B4  // Dword offset AD

#define DP_BKGD_CLR             0x02C0  // Dword offset B0
#define DP_FRGD_CLR             0x02C4  // Dword offset B1
#define DP_WRITE_MASK           0x02C8  // Dword offset B2
#define DP_CHAIN_MASK           0x02CC  // Dword offset B3
#define DP_PIX_WIDTH            0x02D0  // Dword offset B4
#define DP_MIX                  0x02D4  // Dword offset B5
#define DP_SRC                  0x02D8  // Dword offset B6

#define CLR_CMP_CLR             0x0300  // Dword offset C0
#define CLR_CMP_MASK            0x0304  // Dword offset C1
#define CLR_CMP_CNTL            0x0308  // Dword offset C2

#define FIFO_STAT               0x0310  // Dword offset C4

#define CONTEXT_MASK            0x0320  // Dword offset C8
#define CONTEXT_LOAD_CNTL       0x032C  // Dword offset CB

#define GUI_TRAJ_CNTL           0x0330  // Dword offset CC
#define GUI_STAT                0x0338  // Dword offset CE

