; ===========================================================================
; ROMCAL09.ASM
;
; Mach64 ROM interface function 09h - Fill query structure.
;
; Compiling:
;   masm /Ml /D<memory model> romcalls.asm;
;       <memory model> = mem_S for SMALL model,
;                        mem_M for MEDIUM model,
;                        mem_L for LARGE model
;
; Copyright (c) 1993-94 ATI Technologies Inc. All rights reserved
; ===========================================================================

include ..\inc\atim64.inc

IFDEF mem_S
PARM        equ     4   ; passed parameters start at bp+4 for small model
ELSE
PARM        equ     6   ; passed parameters start at bp+6 for other models
ENDIF

IFDEF mem_S
.MODEL  SMALL, C
ELSEIFDEF mem_M
.MODEL  MEDIUM, C
ELSE
.MODEL  LARGE, C
ENDIF

.DATA

rom_addr    dw      64h
            dw      0c000h
            db      0

.CODE
.286

; Macro for 'call' model handling
Mcall       macro   routine
IFDEF mem_S
            call    NEAR PTR routine
ELSE
            call    FAR PTR routine
ENDIF
	        endm

; Externals
IFDEF mem_S
extrn   pgl_getrombase:NEAR
ELSE
extrn   pgl_getrombase:FAR
ENDIF

; ---------------------------------------------------------------------------
; ROM_FILLQUERYSTRUCTURE - ROM function 09h
;
; Fill a query structure containing information about the installed hardware.
; This function should be called after called ROM_GETQUERYSIZE and with the
; same information type flag. This insures that the structure is large
; enough to hold the fill information. Input parameters are fetched from the
; stack. See PGL.H for symbolic values.
;
; Inputs : WORD information type
;            0 - header information only
;            1 - header and mode table information
;
;          FAR POINTER address of structure to be filled (DX:BX)
;
; Outputs: Returns error code in ax
;            0 - no error
;            1 - function complete with error
;            2 - function not supported
; ---------------------------------------------------------------------------
            public  ROM_fillquerystructure

IFDEF mem_S
ROM_fillquerystructure proc near
ELSE
ROM_fillquerystructure proc far
ENDIF
            ; create frame pointer
            push    bp
            mov     bp, sp

            ; save registers used
            push    bx
            push    cx
            push    dx

            ; setup parameters for call to ATI rom
            Mcall   pgl_getrombase              ; get rom segment in ax
            mov     rom_addr+2, ax
            mov     cx, WORD PTR [bp+PARM]      ; get info type flag
            mov     bx, WORD PTR [bp+PARM+2]    ; get offset of address
            mov     dx, WORD PTR [bp+PARM+4]    ; get segment of address

            ; setup ROM call
            mov     ax, 9                       ; function 09h
            mov     rom_addr, 64h
            call    DWORD PTR rom_addr          ; call ROM using FAR CALL

            ; setup error code in AL
            mov     al, ah
            xor     ah, ah

            ; restore saved registers
            pop     dx
            pop     cx
            pop     bx

            ; remove frame pointer
            mov     sp, bp
            pop     bp

            ret

ROM_fillquerystructure endp

            end

